-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.stone:LinkToTarget("questStone")
    self.player0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.active = true
    end
  end
  
  if self.active then
    CheckForPlayer(self)
  end
end

function OnBeforeDeath(self)
  self.stone:TriggerAllTargets()
end

function CheckForPlayer(self)
  p0units = self.player0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
  
  if p0units > 1 then
    self.player0:AddQuest('D09_STONE', 'side')
    Debug:Log("Quest stone added")
    self.active = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("stone")
end
